//
//  Mammifere.hpp
//  Séance 4
//
//  Created by Nicolas Sicard on 23/10/2015.
//  Copyright © 2015 Efrei. All rights reserved.
//

#ifndef Mammifere_hpp
#define Mammifere_hpp

#include <stdio.h>
#include <iostream>

using namespace std;

const string _lesMois[] = { "janvier", "février", "mars", "avril", "mai", "juin", "juillet",
    "août", "septembre", "octobre", "novembre", "décembre"};

class Date {
    unsigned int _jour, _mois, _annee;
public:
    Date(unsigned jour, unsigned mois, unsigned annee) { _jour = jour; _mois=mois, _annee=annee; }
    
    void print() const {
        cout << "le " << _jour << " du mois de " << _lesMois[_mois-1] << " de l'an " << _annee << endl;
    }
};

class Mammifere {
    string  _nom;
    Date    *_dateDeNaissance;
public:
    Mammifere(const string& nom="Mammifere");
    Mammifere(const Mammifere& m);
    ~Mammifere();
    
    Mammifere& operator=(const Mammifere& m);
    
    string getNom() const;
    void setNom(const string& nom);
    
    void se_deplace();
    
    void print() const;

    friend ostream& operator<<(ostream& os, const Mammifere& m);
};


#endif /* Mammifere_hpp */
